<!DOCTYPE html>
<html lang="lv">
<head>
    <meta charset="UTF-8">
    <title>Pārvaldīt Lietotājus</title>
    <link rel="stylesheet" type="text/css" href="../style.css">
    <style>
        h1 {
            text-align: center;
            margin-top: 20px;
            font-size: 24px;
        }
        table {
            width: 80%;
            margin: 20px auto;
            border-collapse: collapse;
        }
        th, td {
            border: 1px solid #ccc;
            padding: 10px;
            text-align: center;
        }
        th {
            background-color: #f4f4f4;
        }
        a {
            padding: 5px 10px;
            background-color: #333;
            color: #fff;
            text-decoration: none;
            border-radius: 3px;
            transition: background-color 0.3s ease;
        }
        a:hover {
            background-color: #555;
        }
        .no-users {
            text-align: center;
            margin-top: 20px;
            font-size: 18px;
        }
    </style>
</head>
<body>
    <?php include('../php/check_admin.php'); ?>

    <!-- Navigācijas josla -->
<div id="navbar">
    <!-- Left-aligned logo -->
    <div id="logo" >LOGO</div>
    <div id="adminBtn">
        <a href="../html/admin_view.html">Admin View</a>
    </div>   
    <div id="profileBtn" class="dropdown" onclick="toggleDropdown()">Profils
        <div class="dropdown-content" id="dropdownContent">
            <a href="../php/logout.php">Iziet</a>
        </div>
    </div>
</div>

    <h1>Pārvaldīt Lietotājus</h1>

    <?php
    $conn = new mysqli("localhost", "root", "", "quiz_db");
    if ($conn->connect_error) {
        die("Savienojums neizdevās: " . $conn->connect_error);
    }

    $sql = "SELECT id, username, email, is_admin FROM users";
    $result = $conn->query($sql);

    if ($result->num_rows > 0) {
        echo '<table>';
        echo '<tr><th>ID</th><th>Lietotājvārds</th><th>E-pasts</th><th>Administrators</th><th>Darbības</th></tr>';

        while ($row = $result->fetch_assoc()) {
            echo '<tr>';
            echo '<td>' . $row["id"] . '</td>';
            echo '<td>' . $row["username"] . '</td>';
            echo '<td>' . $row["email"] . '</td>';
            echo '<td>' . ($row["is_admin"] ? 'Jā' : 'Nē') . '</td>';
            echo '<td>';
            echo '<a href="../php/admin_edit_user.php?user_id=' . $row["id"] . '">Rediģēt</a> ';
            echo '<a href="../php/delete_user.php?user_id=' . $row["id"] . '" onclick="return confirm(\'Vai tiešām vēlaties dzēst šo lietotāju?\')">Dzēst</a>';
            echo '</td>';
            echo '</tr>';
        }

        echo '</table>';
    } else {
        echo '<p class="no-users">Lietotāji nav atrasti.</p>';
    }

    $conn->close();
    ?>

    <script src="../js/redirects.js"></script>
</body>
</html>
